package com.rocogz.account.api.service.account;

import com.rocogz.account.api.request.account.base.*;
import com.rocogz.account.api.response.account.base.AccountOpenRes;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;

/**
 * 账户基础服务
 * @author roco
 */
public interface AccountBaseService {



    /**
     * 开通机构总账户 (非顶级)
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openTopAcct(CommonRequest<AccountOpenTopOrgReq> request);



    /**
     * 开通机构总账户 (非顶级)
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openOrgAcct(CommonRequest<AccountOpenOrgReq> request);
    
    
    /**
     * 开通明细账户(通用/个人/其他)
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openDetailAcct(CommonRequest<AccountOpenDetailReq> request);
    
    
    /**
     * 账户状态变更
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<AccountUpdateStatusReq> request);

    /**
     * 账户状态变更
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateDepositStatus(CommonRequest<AccountDepositUpdateStatusReq> request);

    /**
     * 开通机构投保礼总账户
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openToubaolTopAcct(CommonRequest<AccountOpenTopOrgReq> request);

    /**
     * 开通机构投保礼总账户 (非顶级)
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openToubaolOrgAcct(CommonRequest<AccountOpenOrgReq> request);

    /**
     * 开通投保礼明细账户(通用)
     *
     * @param request
     * @return
     */
    CommonResponse<AccountOpenRes> openToubaolDetailAcct(CommonRequest<AccountOpenDetailReq> request);
    

}
