/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.entity.account.Account;
import com.rocogz.account.api.enums.account.AccountLogType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="account_base_log")
public class AccountLog
implements Serializable {
    @Id
    private Long id;
    private String acctNo;
    private String logType;
    private String description;
    private String remark;
    private String beforeJson;
    private String afterJson;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    private LocalDateTime createTime;
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+08:00")
    private LocalDate createDate;
    private String createUser;
    private String createName;
    @Column(name="create_usertype")
    private String createUsertype;

    public static AccountLog buildOpenLog(Account account) {
        AccountLog accountLog = new AccountLog();
        accountLog.setAcctNo(account.getAcctNo());
        accountLog.setLogType(AccountLogType.OPEN_ACCT.name());
        accountLog.setDescription("\u8d26\u6237\u5f00\u6237");
        accountLog.setRemark(account.getRemark());
        return accountLog;
    }

    public Long getId() {
        return this.id;
    }

    public String getAcctNo() {
        return this.acctNo;
    }

    public String getLogType() {
        return this.logType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getBeforeJson() {
        return this.beforeJson;
    }

    public String getAfterJson() {
        return this.afterJson;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDate getCreateDate() {
        return this.createDate;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public String getCreateName() {
        return this.createName;
    }

    public String getCreateUsertype() {
        return this.createUsertype;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAcctNo(String acctNo) {
        this.acctNo = acctNo;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setBeforeJson(String beforeJson) {
        this.beforeJson = beforeJson;
    }

    public void setAfterJson(String afterJson) {
        this.afterJson = afterJson;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setCreateDate(LocalDate createDate) {
        this.createDate = createDate;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public void setCreateUsertype(String createUsertype) {
        this.createUsertype = createUsertype;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountLog)) {
            return false;
        }
        AccountLog other = (AccountLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$acctNo = this.getAcctNo();
        String other$acctNo = other.getAcctNo();
        if (this$acctNo == null ? other$acctNo != null : !this$acctNo.equals(other$acctNo)) {
            return false;
        }
        String this$logType = this.getLogType();
        String other$logType = other.getLogType();
        if (this$logType == null ? other$logType != null : !this$logType.equals(other$logType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$beforeJson = this.getBeforeJson();
        String other$beforeJson = other.getBeforeJson();
        if (this$beforeJson == null ? other$beforeJson != null : !this$beforeJson.equals(other$beforeJson)) {
            return false;
        }
        String this$afterJson = this.getAfterJson();
        String other$afterJson = other.getAfterJson();
        if (this$afterJson == null ? other$afterJson != null : !this$afterJson.equals(other$afterJson)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDate this$createDate = this.getCreateDate();
        LocalDate other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        String this$createUser = this.getCreateUser();
        String other$createUser = other.getCreateUser();
        if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
            return false;
        }
        String this$createName = this.getCreateName();
        String other$createName = other.getCreateName();
        if (this$createName == null ? other$createName != null : !this$createName.equals(other$createName)) {
            return false;
        }
        String this$createUsertype = this.getCreateUsertype();
        String other$createUsertype = other.getCreateUsertype();
        return !(this$createUsertype == null ? other$createUsertype != null : !this$createUsertype.equals(other$createUsertype));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $acctNo = this.getAcctNo();
        result = result * 59 + ($acctNo == null ? 43 : $acctNo.hashCode());
        String $logType = this.getLogType();
        result = result * 59 + ($logType == null ? 43 : $logType.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $beforeJson = this.getBeforeJson();
        result = result * 59 + ($beforeJson == null ? 43 : $beforeJson.hashCode());
        String $afterJson = this.getAfterJson();
        result = result * 59 + ($afterJson == null ? 43 : $afterJson.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDate $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        String $createUser = this.getCreateUser();
        result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
        String $createName = this.getCreateName();
        result = result * 59 + ($createName == null ? 43 : $createName.hashCode());
        String $createUsertype = this.getCreateUsertype();
        result = result * 59 + ($createUsertype == null ? 43 : $createUsertype.hashCode());
        return result;
    }

    public String toString() {
        return "AccountLog(id=" + this.getId() + ", acctNo=" + this.getAcctNo() + ", logType=" + this.getLogType() + ", description=" + this.getDescription() + ", remark=" + this.getRemark() + ", beforeJson=" + this.getBeforeJson() + ", afterJson=" + this.getAfterJson() + ", createTime=" + this.getCreateTime() + ", createDate=" + this.getCreateDate() + ", createUser=" + this.getCreateUser() + ", createName=" + this.getCreateName() + ", createUsertype=" + this.getCreateUsertype() + ")";
    }
}

