package com.rocogz.account.api.request.account.trade;

import com.rocogz.account.api.enums.account.AccountEventType;
import com.rocogz.account.api.enums.account.AccountSysEventType;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 账户交易参数
 *
 * @author Andrew
 * @create 2020/4/8 3:39 下午
 */
@Data
@ToString(callSuper = true)
public class AccountTradeReq implements Serializable {
    
    @NotBlank
    private String eventNo;
    
    @NotNull(groups = Trading.class)
    private AccountEventType eventType;
    
    @NotBlank
    private String acctNo;
    
    @NotBlank(groups = SysTrading.class)
    private String targetAcctNo;
    
    
    @NotNull(groups = SysTrading.class)
    private AccountSysEventType sysEventType;
    
    @NotNull
    @Digits(integer = 999999999, fraction = 2)
    @DecimalMin("0.01")
    private BigDecimal amount;
    
    
    @Length(max = 1024)
    private String remark;
    
    
    public interface Trading {}
    
    public interface SysTrading {}
    
    
}
