package com.rocogz.account.api.service.account;

import com.rocogz.account.api.request.account.audit.AccountDepositAuditCommonReq;
import com.rocogz.account.api.request.account.audit.AccountDepositAuditReq;
import com.rocogz.account.api.response.account.audit.AccountDepositAuditDetail;
import com.rocogz.account.api.response.account.audit.AccountDepositAuditRes;
import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;

public interface AccountDepositAuditService {

    /**
     * 备付金交易审核
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDepositAuditRes> applyAudit(CommonRequest<AccountDepositAuditReq> request);

    /**
     * 审核通过 / 审核不通过
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDepositAuditRes> doAudit(CommonRequest<AccountDepositAuditCommonReq> request);

    /**
     * 机构发放
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDepositAuditRes> enterpriseProvide(CommonRequest<AccountDepositAuditCommonReq> request);

    /**
     * 平台发放
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDepositAuditRes> platformProvide(CommonRequest<AccountDepositAuditCommonReq> request);

    /**
     * 获取详情
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDepositAuditDetail> detial(CommonRequest<BaseUniqueCodeRequest> request);


    CommonResponse<Boolean> notifyAudit(CommonRequest<AccountDepositAuditCommonReq> request);

}
