package com.rocogz.supplychain.api.entity.deposit.account;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/13 14:10</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class ScDepositAccountLog implements Serializable {
    private Long id;

    /**
     * 日志类型 CREATE：开户 UPDATE_STATUS 变更状态  UPDATE_SUPPLIER 更改供应商
     */
    private String logType;

    /**
     * 账户编号
     */
    private String acctCode;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 最新供应商编码
     */
    private String supplierNo;

    /**
     * 最新供应商名称
     */
    private String supplierName;

    /**
     * 旧的供应商编码
     */
    private String oldSupplierNo;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

}