package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/2/19 10:52 上午
 */
@Data
@Table(name = "sc_catalog")
public class Catalog implements Serializable {

    /**
     * 分类ID
     */
    @Id
    private Long productCatalogId;
    /**
     * 分类编号
     */
    private String productCatalogNo;
    /**
     * 分类名称
     */
    private String productCatalogName;
    /**
     * 搜索名
     */
    private String searchName;
    /**
     * 序号
     */
    private Integer serialNumber;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;

    /**
     * 层级
     * */
    private Integer level;
    /**
     * 上级id
     */
    private Long pid;
    /**
     * 附加属性，不存数据库
     * */
    @Transient
    private String pname;
    /**
     * 1级层级编码
     */
    private String levelCode1;
    /**
     * 2级层级编码
     */
    private String levelCode2;
    /**
     * 3级层级编码
     */
    private String levelCode3;
    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

    public Long getId(){
        return productCatalogId;
    }
}
