package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author lq
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "sc_seller_contacts")
public class SellerContacts implements Serializable {

	/**
	 * 上游销售商联系人ID
	 */
	@Id
	private Long sellerContactsId;
	/**
	 * 姓名
	 */
	private String fullName;
	/**
	 * 联系电话
	 */
	private String phone;
	/**
	 * 固定电话
	 */
	private String tel;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 上游销售商编码
	 */
	private String sellerNo;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;



    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;

    /**
     * 更新日期
     * */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

}
