package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.enums.supplychain.WhiteListTypeEnum;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: ip白名单</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/13 8:32</dd>
 * <dd>@author：lq</dd>
 * </dl>
 */
@Data
@Table(name = "sc_seller_ip_white_list")
public class SellerIpWhiteList implements Serializable {

    @Id
    private Long id;

    /**
     * 下游销售商编号
     */
    private String sellerNo;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * 备注
     */
    private String remarks;
    /**
     * 白名单类型
     */

    private WhiteListTypeEnum whiteListType=WhiteListTypeEnum.INTERFACE;
    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

}