package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.enums.supplychain.SellerProductOperationTypeEnum;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/14 9:57</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "sc_seller_product_history")
public class SellerProductHistory implements Serializable {

    @Id
    private Long id;

    /**
     * 编码
     */
    private String code;

    /**
     * 上游产品编码
     */
    private String upstreamCode;

    /**
     * 名称
     */
    private String name;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 简称
     */
    private String simpleName;

    /**
     * 类目编码
     */
    private String catalogCode;

    /**
     * 分类名称
     */
    private String catalogName;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 产品摘要
     */
    private String productBrief;

    /**
     * 供应商渠道名称
     */
    private String channelName;

    /**
     * 供应商渠道编号
     */
    private String channelCode;

    /**
     * 下游销售商编码
     */
    private String sellerNo;

    /**
     * 下游销售商名称
     */
    private String sellerName;

    /**
     * 下游渠道商备付金账户编码
     */
    private String acctCode;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 产品面值
     */
    private BigDecimal price;
    /**
     * 产品采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 产品销售价
     */
    private BigDecimal sellPrice;

    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    /**
     * OIL_CARD 油卡产品,THIRD第三方产品
     */
    private String nature;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUsertype;

    /**
     * 操作项
     */
    @Column(name = "operation")
    private SellerProductOperationTypeEnum operation;

}