package com.rocogz.supplychain.api.entity.supplychain;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author lq
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "sc_supplier")
public class Supplier implements Serializable {
	/**
	 * 上游渠道商ID
	 */
    @Id
	private Long supplierId;
	/**
	 * 上游渠道商编号
	 */
	private String supplierNo;
	/**
	 * 上游渠道商名称
	 */
	private String supplierName;

	/**
	 * 上游渠道
	 */
	private String supplierChannel;
	/**
	 * 简介
	 */
	private String description;
	/**
	 * 地区编号
	 */
	private String regionNo;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;

    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    /**
     * 区
     */
    private String areaCode;
	/**
	 * 详细地址
	 */
	private String address;
	/**
	 * 法人
	 */
	private String legalPerson;
	/**
	 * 营业执照编号
	 */
	private String businessLicenseNo;
	/**
	 * 营业执照图片(阿里云)
	 */
	private String businessLicenseImg;
	/**
	 * 状态
	 */
	private Integer status;

	/**
	 * 搜索名
	 */
	private String searchName;
	/**
	 * 营业执照名称
	 * */
	private String licenseName;
    /**
     * 营业执照名称
     * */
    private String licenseNamePy;
    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;

    /**
     * 更新日期
     * */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;
}
