package com.rocogz.supplychain.api.entity.supplychain;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.enums.supplychain.SupplierOperationTagEnum;
import com.rocogz.supplychain.api.enums.supplychain.SupplierOperationTypeEnum;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**<p>Title:销售商 </p>
 * <p>日期：2019-05-31 20:03:54</p>
 * <p>版本：1.0</p>
 * @author lanqian
 */
@Data
@Table(name = "sc_supplier_operation_log")
public class SupplierOperationLog implements Serializable {
    @Id
    private Long id;
    /**
     * 标签位置
     */
    @Column(name = "tag_name")
    private SupplierOperationTagEnum tagName;

    /**
     * 操作项
     */
    @Column(name = "operation")
    private SupplierOperationTypeEnum operation;

    /**
     * 渠道商编号
     */
    private String supplierNo;
    /**
     * 备注
     */
    private String remarks;

    /**
     * 修改前对象的json字符串
     */
    private String oldValue;

    /**
     * 修改后对象的json字符串
     */
    private String newValue;

    /**
     * 信息
     */
    private String message;
    /**
      * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;
}