package com.rocogz.supplychain.api.enums.deposit.account;

import lombok.Getter;

/**
 * 备付金账户操作枚举类
 *
 * @author djt
 * @date 2020/5/13 20:47
 */
public enum ScDepositAccountOperationEnum {
    /**
     * 冻结
     */
    FREEZE(new ScDepositAccountStatusEnum[]{ScDepositAccountStatusEnum.OPEN}, ScDepositAccountStatusEnum.FREEZE),

    /**
     * 解冻
     */
    UNFREEZE(new ScDepositAccountStatusEnum[]{ScDepositAccountStatusEnum.FREEZE}, ScDepositAccountStatusEnum.OPEN),

    /**
     * 停用
     */
    STOP(new ScDepositAccountStatusEnum[]{ScDepositAccountStatusEnum.FREEZE, ScDepositAccountStatusEnum.OPEN}, ScDepositAccountStatusEnum.CLOSE),

    /**
     * 启用
     */
    START(new ScDepositAccountStatusEnum[]{ScDepositAccountStatusEnum.CLOSE}, ScDepositAccountStatusEnum.OPEN);

    @Getter
    private ScDepositAccountStatusEnum[] beforeStatus;

    @Getter
    private ScDepositAccountStatusEnum afterStatus;

    ScDepositAccountOperationEnum(ScDepositAccountStatusEnum[] beforeStatus, ScDepositAccountStatusEnum afterStatus) {
        this.beforeStatus = beforeStatus;
        this.afterStatus = afterStatus;
    }
}
