package com.rocogz.supplychain.api.enums.supplychain;

import lombok.Getter;

public enum SellerStatus {
    /**
     * 停用
     */
    STOP_USING(0,"停用"),

    /**
     * 启用
     */
    START_USING(1,"启用");

    @Getter
    private Integer code;

    @Getter
    private String name;

    SellerStatus(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        for (SellerStatus status : values()) {
            if (status.code.equals(i)) {
                return status.getName();
            }
        }
        return null;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
