package com.rocogz.supplychain.api.request.deposit.account.trans;

import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTransTypeEnum;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author djt
 * @date 2020/5/19 14:07
 */
@Data
public class ScDepositAccountTransCommonReq implements Serializable {

    /**
     * 事件编号
     */
    @Length(max = 64)
    @NotBlank
    private String eventNo;


    /**
     * 事件类型
     */
    @NotBlank
    private String eventType;


    /**
     * 交易类型
     */
    @NotNull(message = "交易类型不能为空")
    private ScDepositAccountTransTypeEnum transType;


    /**
     * 备注
     */
    @Length(max = 200)
    private String remark;
}
