package com.rocogz.supplychain.api.request.supplychain.catalog;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
@Data
public class CatalogSaveReq implements Serializable {

	/**
	 * 分类ID
	 */
	private Long productCatalogId;
	/**
	 * 分类名称
	 */
	@NotBlank(message = "分类名称不允许为空")
	private String productCatalogName;
	/**
	 * 序号
	 */
	@NotNull(message = "排序值不允许为空")
    @Min(1)
	private Integer serialNumber;
	/**
	 * 状态(1启用,0停用)
	 */
    @NotNull(message = "状态不可为空")
	private Integer status;

	/**
	 * 上级id
	 */
	private Long pid;
	/**
	 * 是否删除
	 */
	private Boolean deleted;

}
