package com.rocogz.supplychain.api.request.supplychain.seller;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**<p>Title:销售商 </p>
 * <p>Description:对应表名：sc_seller  </p>
 * <p>日期：2019-05-31 20:03:54</p>
 * <p>版本：1.0</p>
 * @author lanqian
 */
@Data
public class SellerSaveReq implements Serializable {
	

	/**
	 * 销售商ID
	 */
	private Long sellerId;
    /**
     * 销售商编号
     */
    private String sellerNo;
	/**
	 * 销售商名称
	 */
	@NotBlank
	private String sellerName;
	/**
	 * 简介
	 */
	private String description;
	/**
	 * 地区编号
	 */
	private String regionNo;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;
    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    /**
     * 区
     */
    private String areaCode;
	/**
	 * 详细地址
	 */
	private String address;
	/**
	 * 法人
	 */
	private String legalPerson;
	/**
	 * 营业执照编号
	 */
	private String businessLicenseNo;
	/**
	 * 营业执照图片(阿里云)
	 */
	private String businessLicenseImg;
	/**
	 * 状态
	 */
    @NotNull
	@Min(0)
	@Max(1)
	private Integer status;
	/**
	 * 联系人列表
	 */
	private List<SellerContactsReq> contacts;
	/**
	 * 营业执照名称
	 * */
	private String licenseName;

}
