package com.rocogz.supplychain.api.request.supplychain.seller.product;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/2/19 11:15 上午
 */
@Data
public class SellerProductReq implements Serializable {

    private Long id;
    /**
     * 产品编号
     */
    private String code;
    /**
     * 名称
     */
    private String name;

    /**
     * 简称
     */
    private String simpleName;
    /**
     * 类目编码
     */
    private String catalogCode;
    /**
     * 分类名称
     */
    private String catalogName;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 下游销售商编码
     */
    private String sellerNo;

    /**
     * 下游销售商名称
     */
    private String sellerName;

    /**
     * 下游销售商备付金账户编码
     */
    private String acctCode;
    /**
     *  账户名称
     */
    private String acctName;
    /**
     * 面值
     */
    private BigDecimal price;
    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    /**
     * 上游游产品编号
     */
    private String upstreamCode;


}
