package com.rocogz.supplychain.api.service.supplier;


import com.rocogz.common.api.request.BasePrimaryKeyRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.request.NoArgsRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.supplychain.Brand;
import com.rocogz.supplychain.api.request.supplychain.brand.BrandQueryReq;
import com.rocogz.supplychain.api.request.supplychain.brand.BrandSaveReq;
import com.rocogz.supplychain.api.request.supplychain.brand.BrandUpdateReq;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/21 11:11 上午
 */
public interface BrandService {

    CommonResponse<Brand> detail(CommonRequest<BasePrimaryKeyRequest> request);

    CommonResponse<Boolean> save(CommonRequest<BrandSaveReq> request);

    CommonResponse<Boolean> update(CommonRequest<BrandUpdateReq> request);

    CommonResponse<Boolean> delete(CommonRequest<BasePrimaryKeyRequest> request);

    CommonResponse<List<Brand>> find(CommonRequest<BrandQueryReq> request);

    CommonQueryPageResponse<Brand> page(CommonQueryPageRequest<BrandQueryReq> request);

    CommonResponse<Integer> getMaxSerialNumber(CommonRequest<NoArgsRequest> request);

}
