package com.rocogz.supplychain.api.service.supplier;

import com.rocogz.common.api.request.BasePrimaryKeyRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.request.NoArgsRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.supplychain.Catalog;
import com.rocogz.supplychain.api.request.supplychain.catalog.CatalogPageReq;
import com.rocogz.supplychain.api.request.supplychain.catalog.CatalogReq;
import com.rocogz.supplychain.api.request.supplychain.catalog.CatalogSaveReq;
import com.rocogz.supplychain.api.request.supplychain.catalog.CatalogUpdateStatusReq;
import com.rocogz.supplychain.api.response.supplychain.CatalogDto;
import com.rocogz.supplychain.api.response.tree.ZtreeDto;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
public interface CatalogService {
    /**
     * 查询单条记录
     * @param  request
     * @return Catalog
     */
    CommonResponse<Catalog> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 新增保存类目
     * */
    CommonResponse<Boolean> save(CommonRequest<CatalogSaveReq> request);
    /**
     * 更新类目记录
     * */
    CommonResponse<Boolean> update(CommonRequest<CatalogSaveReq> request);
    /**
     * 删除类目
     * 参数 id
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 产品分类列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<Catalog> search(CommonQueryPageRequest<CatalogPageReq> request);

    /**
     * 查询全部产品分类
     * @param request
     * @return
     */
    CommonResponse<List<Catalog>> all(CommonRequest<CatalogReq> request);

    /**
     * 获取最大排序值加1
     * 参数 pid
     * @return
     */
    CommonResponse<Integer> getMaxSerialNumberByPid(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 获取类目信息，构建前端树形选择框
     * */

    CommonResponse<List<ZtreeDto>> getCategoryZTreeList(CommonRequest<NoArgsRequest> request);

    /**
     * 获取类目的树形列表
     * */
    CommonResponse<List<CatalogDto>> findCategoryTree(CommonRequest<NoArgsRequest> request);

    /**
     * 根据ID获取类目和父类目信息
     * */
    CommonResponse<Catalog> getCatalogById(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 更新类目状态
     * */
    CommonResponse<Boolean> updateStatus(CommonRequest<CatalogUpdateStatusReq> request);

    /**
     * 根据code获取类目和父类目信息
     * */
    CommonResponse<Catalog> getByCode(CommonRequest<CatalogReq> request);
}
