package com.rocogz.supplychain.api.service.supplier;

import com.rocogz.common.api.request.BasePrimaryKeyRequest;
import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.supplychain.SupplierProduct;
import com.rocogz.supplychain.api.entity.supplychain.SupplierProductHistory;
import com.rocogz.supplychain.api.request.supplychain.supplier.product.*;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
public interface SupplierProductService {

    /**
     * 新增产品
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SupplierProductSaveReq> request);


    /**
     * 分页查询产品
     * @param request
     * @return
     */
    CommonQueryPageResponse<SupplierProduct> page(CommonQueryPageRequest<SupplierProductPageReq> request);

    /**
     * 产品详情
     * @param request
     * @return
     */
    CommonResponse<SupplierProduct> detail(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 变更状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SupplierProductStatusUpdateReq> request);


    /**
     * 产品修改
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<SupplierProductUpdateReq> request);



    /**
     * 根据产品编号查询产品详情
     * @param request
     * @return
     */
    CommonResponse<SupplierProduct> detailByCode(CommonRequest<SupplierProductDetailReq> request);
    /**
     * 根据产品编号查询产品变更历史
     * @param request
     * @return
     */
   CommonQueryPageResponse<SupplierProductHistory> history(CommonQueryPageRequest<SupplierProductPageReq> request);


   CommonResponse<SupplierProduct> getSimpleByCode(CommonRequest<BaseUniqueCodeRequest> request);
    
}
