package com.rocogz.supplychain.api.request.deposit.account.trans;

import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountReserveEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 备付金交易基础参数
 *
 * @author djt
 * @create 2020/5/14 13:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScDepositAccountRepaymentReq implements Serializable {

    /**
     * 借款记录编码
     */
    @NotBlank(message = "借款记录编码不能为空")
    private String loanNo;

    /**
     * 备付金编码
     */
    @NotBlank(message = "备付金账户编码不能为空")
    private String acctCode;

    /**
     * 交易金额
     */
    @DecimalMin("0.01")
    @Digits(integer = 9, fraction = 3)
    @NotNull(message = "还款金额不能为空")
    private BigDecimal amount;

    /**
     * 还款备注
     */
    private String remark;

}
