package com.rocogz.supplychain.api.service.deposit.account;

import com.rocogz.common.api.request.BasePrimaryKeyRequest;
import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.deposit.account.ScDepositAccount;
import com.rocogz.supplychain.api.request.deposit.account.*;

import java.util.List;

/**
 * 备付金账户服务
 *
 * @author djt
 * @date 2020/5/13 15:36
 */
public interface ScDepositAccountService {

    /**
     * 创建备付金账户
     *
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccount> create(CommonRequest<ScDepositAccountSaveReq> request);


    /**
     * 变更备付金账户
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> edit(CommonRequest<ScDepositAccountUpdateReq> request);


    /**
     * 变更备付金账户状态
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<ScDepositAccountUpdateStatusReq> request);


    /**
     * 根据备付金id获取备付金账户基础信息
     *
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccount> baseDetailById(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 根据备付金账户编码获取备付金账户基础信息
     *
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccount> baseDetailByCode(CommonRequest<BaseUniqueCodeRequest> request);


    /**
     * 根据条件分页查询备付金账户
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<ScDepositAccount> page(CommonQueryPageRequest<ScDepositAccountPageReq> request);

    /**
     * 根据条件不分页查询备付金账户
     *
     * @param request
     * @return
     */
    CommonResponse<List<ScDepositAccount>> all(CommonRequest<ScDepositAccountPageReq> request);


}

