package com.rocogz.supplychain.api.entity.deposit.account;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Table(name = "sc_deposit_account_loan_record")
public class ScDepositAccountLoanRecord implements Serializable {
    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 交易流水号(sc_deposit_account_trans_record.trans_no)
     */
    @Column(name = "trans_no")
    private String transNo;

    /**
     * 借款流水号
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * 账户编号
     */
    @Column(name = "acct_code")
    private String acctCode;

    /**
     * 借款金额
     */
    private BigDecimal amount;

    /**
     * 状态(INIT-未还款,REPAYMENT-已还款)
     */
    private String state;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private String createUser;

    /**
     * 创建日期
     */
    @Column(name = "create_date")
    private LocalDate createDate;

    /**
     * 创建人姓名
     */
    @Column(name = "create_name")
    private String createName;
}