package com.rocogz.supplychain.api.entity.deposit.account;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountLoadStateEnum;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountReserveEnum;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/14 11:36</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class ScDepositAccountTransRecord implements Serializable {
    private Long id;

    /**
     * 交易流水号
     */
    private String transNo;

    /**
     * 日志编号
     */
    private String logNo;

    /**
     * 事件编号
     */
    private String eventNo;

    /**
     * 事件类型
     */
    private String eventType;

    /**
     * 账户编号
     */
    private String acctCode;

    /**
     * 账户类型
     */
    private String acctType;

    /**
     * 请求流水号
     */
    private String reqNo;

    /**
     * 交易类型 {@see  com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTransTypeEnum}
     */
    private String transType;

    /**
     * 流水类型    {@see  com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTransRecordTypeEnum}
     */
    private String recordType;

    /**
     * 交易金额
     */
    private BigDecimal amount;

    /**
     * 变更后余额
     */
    private BigDecimal afterBalance;

    /**
     * 变更后累计充值金额
     */
    private BigDecimal afterRechargeAmount;


    /**
     * 变更后已用金额
     */
    private BigDecimal afterUsedAmount;


    /**
     * 变更后撤回金额
     */
    private BigDecimal afterRevokedAmount;

    /**
     * 变更后扣款额度
     */
    private BigDecimal afterDeductedAmount;

    /**
     * 变更后累计订单数
     */
    private Integer afterUsedCnt;


    /**
     * 变更后撤回数
     */
    private Integer afterRevokedCnt;

    /**
     * 变更后累计充值数
     */
    private Integer afterRechargeCnt;

    /**
     * 变更后累计扣款数
     */
    private Integer afterDeductedCnt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 备付金隐藏属性   {@link com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountHiddenAttributeEnum}
     */
    private String hiddenAttribute;

    @Column(name = "reserve_type")
    private ScDepositAccountReserveEnum reserveType;


}