package com.rocogz.supplychain.api.request.deposit.account;

import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountBusinessNature;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountHiddenAttributeEnum;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountStatusEnum;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTypeEnum;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author djt
 * @date 2020/5/13 15:29
 */
@Data
public class ScDepositAccountSaveReq implements Serializable {

    /**
     *  账户名称
     */
    @Length(max = 100,message = "账户名称不能超过100字符")
    @NotBlank(message = "账户名称不能为空")
    private String acctName;

    /**
     * 关联供应商编码
     */
    @NotBlank(message = "供应商不能为空")
    private String supplierNo;

    /**
     * 备付金账户类型
     */
    @NotNull(message = "备付金账户类型不能为空")
    private ScDepositAccountTypeEnum type;


    /**
     * 业务性质， 销售商备付金需要指定
     */
    private ScDepositAccountBusinessNature businessNature;

    /**
     *  备注
     */
    @Length(max = 500,message = "备注不能超过500个字符")
    private String remark;


    @NotNull(message = "状态不能为空")
    private ScDepositAccountStatusEnum status;


    private ScDepositAccountHiddenAttributeEnum hiddenAttribute;
}
