package com.rocogz.supplychain.api.service.supplier;


import com.rocogz.common.api.request.*;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.supplychain.Seller;
import com.rocogz.supplychain.api.entity.supplychain.SellerApiParameter;
import com.rocogz.supplychain.api.entity.supplychain.SellerIpWhiteList;
import com.rocogz.supplychain.api.request.supplychain.seller.*;
import com.rocogz.supplychain.api.response.supplychain.SellerRes;

import java.util.List;

public interface SellerService {

    /**
     * 查询单条记录
     *
     * @param request
     */
    CommonResponse<SellerRes> get(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 保存
     *
     * @param request
     */
    CommonResponse<Boolean> save(CommonRequest<SellerSaveReq> request);

    /**
     * 更新
     *
     * @param request
     */
    CommonResponse<Boolean> update(CommonRequest<SellerSaveReq> request);

    /**
     * 删除
     *
     * @param request
     */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 供应商列表
     */
    CommonQueryPageResponse<Seller> search(CommonQueryPageRequest<SellerPageReq> request);

    /**
     * 根据供应商状态为启用
     * 是否默认 isDefault
     * 获取供应商信息
     */
    CommonResponse<List<Seller>> all(CommonRequest<SellerReq> request);

    /**
     * 更新状态
     *
     * @param request
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SellerUpdateStatusReq> request);

    CommonResponse<SellerRes> getByCode(CommonRequest<SellerReq> request);


    CommonResponse<Seller> getSimpleByCode(CommonRequest<BaseUniqueCodeRequest> request);


    /**
     * 导出
     */
    CommonResponse<List<Seller>> export(CommonRequest<SellerPageReq> request);

    /**
     * 数据清洗
     */
    CommonResponse<Boolean> processData(CommonRequest<NoArgsRequest> request);

    /**
     * 查询全部
     *
     * @param request
     * @return
     */
    CommonResponse<List<SellerRes>> getByCodes(CommonRequest<SellerCodesReq> request);

    /**
     * 修改白名单
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> editIpWhiteList(CommonRequest<SellerIPWhiteListReq> request);

    /**
     * 查询白名单
     *
     * @param request
     * @return
     */
    CommonResponse<List<SellerIpWhiteList>> getIpWhiteList(CommonRequest<SellerIPWhiteListReq> request);


    /**
     * 获取api 参数
     *
     * @param request
     * @return
     */
    CommonResponse<SellerApiParameter> getApiParam(CommonRequest<BaseUniqueCodeRequest> request);

    /**
     * 变更api参数
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateApiParam(CommonRequest<BaseUniqueCodeRequest> request);


    /**
     * 获取api参数
     * @param request  appId
     * @return
     */
    CommonResponse<SellerApiParameter> getApiParamByAppId(CommonRequest<SellerApiParamReq> request);

}
