package com.rocogz.supplychain.api.entity.deposit.account;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author zhanghongshan
 * 借还款记录
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScDepositAccountLoanRepayMentRecordExt implements Serializable {

    /**
     * 交易流水号(sc_deposit_account_trans_record.trans_no)
     */
    @Column(name = "trans_no")
    private String transNo;

    /**
     * 借款流水号
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * 账户编号
     */
    @Column(name = "acct_code")
    private String acctCode;

    /**
     * 借款金额
     */
    private BigDecimal amount;

    /**
     * 状态(INIT-未还款,REPAYMENT-已还款)
     */
    private String state;


    /**
     * 创建时间
     */
    @Column(name = "load_time")
    private LocalDateTime loanTime;


    /**
     * 还款金额
     */
    @Column(name = "repayment_amount")
    private BigDecimal repaymentAmount;

    /**
     * 还款时间
     */
    @Column(name = "repayment_time")
    private LocalDateTime repaymentTime;

    /**
     * 还款编号
     */
    @Column(name = "repayment_no")
    private String repaymentNo;

    /**
     * 借还款操作人
     */
    @Column(name = "create_name")
    private String createName;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
}