package com.rocogz.supplychain.api.entity.electric.southern;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 南网渠道商充值卡信息
 */
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
@Table(name="sc_electric_recharge_card")
public class ElectricRechargeCard extends IdEntity {

    /**
     * 批次号
     */
    private String batchId;

    /**
     * 充值卡ID
     */
    private String rechargeId;

    /**
     * 充值卡类型
     */
    private String rechargeType;

    /**
     * 充值卡名称
     */
    private String rechargeName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

}