package com.rocogz.supplychain.api.entity.electric.southern;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 南网渠道商充值卡所属批次信息
 */
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
@Table(name="sc_electric_recharge_card_batch")
public class ElectricRechargeCardBatch extends IdEntity {

    /**
     * 批次ID
     */
    private String batchId;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 批次发卡额度
     */
    private String batchHairpinQuota;

    /**
     * 批次可用余额
     */
    private String balanceHairpin;

    /**
     * 生效时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate effectiveDate;

    /**
     * 失效时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate invalidDate;

    /**
     * 发卡开始时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate hairpinStartTime;

    /**
     * 发卡截止时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate hairpinEndTime;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 充值卡信息
     */
    private List<ElectricRechargeCard> rechargeCardList;

}