package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 下游备付金api参数
 * @author djt
 * @date 2020/5/13 17:21
 */
@Data
@Table(name = "sc_seller_api_parameter")
public class SellerApiParameter implements Serializable {
    private Long id;

    /**
     * 销售商编码
     */
    private String sellerNo;

    /**
     * 对接下游系统app_id
     */
    private String appId;


    /**
     * 对接下游系统app_secret
     */
    private String appSecret;

    private Long createUser;

    private String createName;

    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;
}
