package com.rocogz.supplychain.api.entity.supplychain;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Collections;
import java.util.List;

/**
 * <dl>
 * <dd>Description:Shiro用户的数据权限</dd>
 * <dd>@date: 2020/08/19</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class ShiroUserDataPermission {

    /**
     * 是否有所有选择,特点是包含了*时 为true
     * false可能有两种情况
     * 1.如果dataPermissions没有数据 这个用户没有设置过任何权限
     * 2.如果dataPermissions有数据，这个用户有部分权限
     */
    private Boolean allPermission;
    /**
     * code集合，code是编码，比如供应商编码，专区编码等
     */
    private List<String> dataPermissions;

    /**
     * 如果没有设置过任何权限 认为是空权限 没有任何权限
     * @return
     */
    public static ShiroUserDataPermission emptyPermission(){ return
            new ShiroUserDataPermission(false,Collections.emptyList());}


}
