package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author lq
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "sc_supplier_contacts")
public class SupplierContacts implements Serializable {

	/**
	 * 上游渠道商联系人ID
	 */
	@Id
	private Long supplierContactsId;
	/**
	 * 姓名
	 */
	private String fullName;
	/**
	 * 联系电话
	 */
	private String phone;
	/**
	 * 固定电话
	 */
	private String tel;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 上游渠道商编码
	 */
	private String supplierNo;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;
    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate updateDate;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

}
