package com.rocogz.supplychain.api.request.deposit.account.trans;

import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountReserveEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 备付金交易基础参数
 *
 * @author djt
 * @create 2020/5/14 13:45
 */
@ToString(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScDepositAccountTransParam extends ScDepositAccountTransCommonReq {


    /**
     * 请求流水
     */
    @NotBlank
    private String reqNo;


    /**
     * 备付金编码
     */
    @NotBlank(message = "备付金账户编码不能为空")
    private String acctCode;


    /**
     * 交易金额
     */
    @DecimalMin("0.01")
    @Digits(integer = 9, fraction = 3)
    @NotNull
    private BigDecimal amount;


    /**
     * 充值类型
     */
    private ScDepositAccountReserveEnum reserve;

}
