package com.rocogz.supplychain.api.service.deposit.account;

import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.deposit.account.ScDepositAccountLoanRepayMentRecordExt;
import com.rocogz.supplychain.api.entity.deposit.account.ScDepositAccountLoanRepaymentStatistic;
import com.rocogz.supplychain.api.entity.deposit.account.ScDepositAccountTransRecord;
import com.rocogz.supplychain.api.entity.deposit.account.ext.ScDepositAccountTransRecordSummary;
import com.rocogz.supplychain.api.entity.deposit.account.ext.ScDepositAccountTransRecordSummaryTotal;
import com.rocogz.supplychain.api.request.deposit.account.trans.*;
import com.rocogz.supplychain.api.response.deposit.account.ScDepositAccountTransResult;

import java.util.List;

/**
 * 备付金账户服务
 * @author djt
 * @date 2020/5/13 15:36
 */
public interface ScDepositAccountTransService {

    /**
     * 交易
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccountTransResult> trans(CommonRequest<ScDepositAccountTransReq> request);


    /**
     * 查询交易流水
     * @param request
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountTransRecord> transRecord(CommonQueryPageRequest<ScDepositAccountTransRecordQueryReq> request);

    /**
     * 每日汇总
     * @param request
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountTransRecordSummary> summaryDay(CommonQueryPageRequest<ScDepositAccountSummaryQueryReq> request);


    /**
     * 汇总
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccountTransRecordSummaryTotal> summary(CommonRequest<ScDepositAccountSummaryQueryReq> request);


    /**
     * 借款列表
     * @param req
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountLoanRepayMentRecordExt> loadPage(CommonQueryPageRequest<ScDepositAccountLoadRepayQueryReq> req);

    /**
     * 借款列表导出
     * @param req
     * @return
     */
    CommonResponse<List<ScDepositAccountLoanRepayMentRecordExt>> loanExport(CommonRequest<ScDepositAccountLoadRepayQueryReq> req);

    /**
     * 还款列表
     * @param req
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountLoanRepayMentRecordExt> repayPage(CommonQueryPageRequest<ScDepositAccountLoadRepayQueryReq> req);

    /**
     * 还款列表导出
     * @param req
     * @return
     */
    CommonResponse<List<ScDepositAccountLoanRepayMentRecordExt>> repayExport(CommonRequest<ScDepositAccountLoadRepayQueryReq> req);

    /**
     * 还款更新
     * @param req
     * @return
     */
    CommonResponse<Boolean> repayment(CommonRequest<ScDepositAccountRepaymentReq> req);

    /**
     * 借还款累计统计
     * @param req
     * @return
     */
    CommonResponse<ScDepositAccountLoanRepaymentStatistic> loadRepaymentStatistic(CommonRequest<ScDepositAccountLoadRepayQueryReq> req);

    /**
     * 备付金充值记录导出
     * @param req
     * @return
     */
    CommonResponse<List<ScDepositAccountTransRecord>> transRecordExport(CommonRequest<ScDepositAccountTransRecordQueryReq> req);

}

