package com.rocogz.supplychain.api.entity.deposit.account;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountBusinessNature;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/13 13:36</dd>
 * <dd>@author：djt</dd>
 * </dl>
 */
@Data
@Table(name = "sc_deposit_account")
public class ScDepositAccount implements Serializable {

    @Id
    private Long id;

    /**
     * 账户编码
     */
    private String acctCode;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户名称拼音
     */
    private String acctNamePinYin;

    /**
     * 累计调增额度
     */
    private BigDecimal accumulatedRechargeAmount;

    /**
     * 累计调增数
     */
    private Integer accumulatedRechargeCnt;

    /**
     * 累计调减额度
     */
    private BigDecimal accumulatedDeductedAmount;


    /**
     * 累计调减数
     */
    private Integer accumulatedDeductedCnt;


    /**
     * 累计已用额度
     */
    private BigDecimal accumulatedUsedAmount;


    /**
     * 累计使用数
     */
    private Integer accumulatedUsedCnt;

    /**
     * 累计撤回额度
     */
    private BigDecimal accumulatedRevokedAmount;

    /**
     * 累计撤回数
     */
    private Integer accumulatedRevokedCnt;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态：
     */
    private String status;

    /**
     * 关联商户编码
     */
    private String supplierNo;

    /**
     * 关联商户名称
     */
    private String supplierName;

    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    private Long createUser;

    private String createName;

    private LocalDateTime updateTime;

    private Integer updateUser;


    private String updateName;

    /**
     * 余额更新时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime balanceUpdateTime;

    /**
     * 备付金账户类型 {@link com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTypeEnum}
     */
    private String type;


    /**
     * 业务性质 type== SELLER 才有 {@link ScDepositAccountBusinessNature}
     */
    private String businessNature;

}