package com.rocogz.supplychain.api.enums.deposit.account;

import lombok.Getter;

/**
 * @author djt
 * @date 2020/5/13 13:47
 */
public enum ScDepositAccountTransTypeEnum {


    DEDUCTION("调减"),

    RESERVE("充值"),


    ORDER_TOP_UP("扣款"),


    ORDER_REFUND("退款");


    @Getter
    private String desc;

    ScDepositAccountTransTypeEnum(String desc) {
        this.desc = desc;
    }


    public static String getDescByName(String name) {
        try {
            return ScDepositAccountTransTypeEnum.valueOf(name).desc;
        } catch (Exception e) {
            return name;
        }
    }

}
