package com.rocogz.supplychain.api.service.deposit.account;

import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.deposit.account.ScDepositAccountTransRecord;
import com.rocogz.supplychain.api.entity.deposit.account.ext.ScDepositAccountTransRecordSummary;
import com.rocogz.supplychain.api.entity.deposit.account.ext.ScDepositAccountTransRecordSummaryTotal;
import com.rocogz.supplychain.api.request.deposit.account.trans.ScDepositAccountSummaryQueryReq;
import com.rocogz.supplychain.api.request.deposit.account.trans.ScDepositAccountTransRecordQueryReq;
import com.rocogz.supplychain.api.request.deposit.account.trans.ScDepositAccountTransReq;
import com.rocogz.supplychain.api.response.deposit.account.ScDepositAccountTransResult;

/**
 * 备付金账户服务
 * @author djt
 * @date 2020/5/13 15:36
 */
public interface ScDepositAccountTransService {

    /**
     * 交易
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccountTransResult> trans(CommonRequest<ScDepositAccountTransReq> request);


    /**
     * 查询交易流水
     * @param request
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountTransRecord> transRecord(CommonQueryPageRequest<ScDepositAccountTransRecordQueryReq> request);

    /**
     * 每日汇总
     * @param request
     * @return
     */
    CommonQueryPageResponse<ScDepositAccountTransRecordSummary> summaryDay(CommonQueryPageRequest<ScDepositAccountSummaryQueryReq> request);


    /**
     * 汇总
     * @param request
     * @return
     */
    CommonResponse<ScDepositAccountTransRecordSummaryTotal> summary(CommonRequest<ScDepositAccountSummaryQueryReq> request);

}

