package com.rocogz.supplychain.api.entity.supplychain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/2/19 10:47 上午
 */
@Data
@Table(name = "sc_brand")
public class Brand implements Serializable {

    @Id
    private Long brandId;
    /**
     * 品牌编号
     */
    private String brandNo;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 序号
     */
    private Integer serialNumber;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;

    /**
     * 搜索名
     */
    private String searchName;

    private String createUser;

    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    private String updateUser;

    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

}
