package com.rocogz.supplychain.api.request.deposit.account;

import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author djt
 * @date 2020/5/13 15:29
 */
@Data
public class ScDepositAccountUpdateReq extends BaseUniqueCodeRequest {


    /**
     * 账户名称
     */
    @Length(max = 100, message = "账户名称不能超过100字符")
    @NotBlank(message = "账户名称不能为空")
    private String acctName;


    /**
     * 备注
     */
    @Length(max = 500, message = "备注不能超过500个字符")
    private String remark;
}
