package com.rocogz.supplychain.api.response.deposit.account;

import com.rocogz.supplychain.api.enums.deposit.account.ScDepositAccountTransTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author djt
 * @create 2020/4/8 3:52 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ScDepositAccountTransResult implements Serializable {

    /**
     * 备付金账户编号
     */
    private String acctCode;

    /**
     * 请求流水号
     */
    private String reqNo;



    /**
     * 事件编号
     */
    private String eventNo;


    /**
     * 交易流水号
     */
    private String transNo;


    /**
     * 日志编号
     */
    private String logNo;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 请求类型
     */
    private ScDepositAccountTransTypeEnum transType;

}
