package com.rocogz.supplychain.api.entity.deposit.account;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/14 11:36</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name="sc_deposit_account_trans_req_log")
public class ScDepositAccountTransReqLog  implements Serializable {

    @Id
    private Long id;

    /**
     * 日志编号
     */
    private String logNo;

    /**
     * 事件编号
     */
    private String eventNo;

    /**
     * 事件类型
     */
    private String eventType;

    /**
     * 交易请求参数
     */
    private String reqParam;

    /**
     * 请求md5
     */
    private String reqMd5;

    /**
     * 响应结果
     */
    private String result;


    /**
     * 异常描述
     */
    private String errorMsg;


    /**
     * 响应json
     */
    private String resJson;


    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate updateDate;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime finishTime;

    /**
     * 完成日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate finishDate;

    /**
     * 备注
     */
    private String remark;

}