package com.rocogz.supplychain.api.entity.deposit.account.ext;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Andrew
 * @create 2020/6/23 10:29 上午
 */
@Data
public class ScDepositAccountTransRecordSummaryTotal implements Serializable {

    private BigDecimal addTotalAmount;

    private Integer addTotal;

    private BigDecimal decrTotalAmount;

    private Integer decrTotal;

    private BigDecimal rechargeTotalAmount;

    private Integer rechargeTotal;

    private BigDecimal refundTotalAmount;

    private Integer refundTotal;

    /**
     * 总金额
     * 充值-调减-发放+退款
     * @return
     */
    public BigDecimal getTotalAmount() {
        return addTotalAmount.subtract(decrTotalAmount).subtract(rechargeTotalAmount).add(refundTotalAmount);
    }

}
