package com.rocogz.supplychain.api.request.supplychain.supplier.product;

import com.rocogz.supplychain.api.enums.supplychain.ChannelProductTypeEnum;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/2/19 11:15 上午
 */
@Data
public class SupplierProductSaveReq implements Serializable {

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 简称
     */
    @NotBlank(message = "简称不能为空")
    private String simpleName;
    /**
     * 类目编码
     */
    @NotBlank(message = "分类不能为空")
    private String catalogCode;
    /**
     * 分类名称
     */
    private String catalogName;
    /**
     * 品牌编码
     */
    @NotBlank(message = "品牌不能为空")
    private String brandCode;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 供应商编号
     */
    @NotBlank(message = "上游供应商编码不能为空")
    private String supplierNo;

    /**
     * * 上游渠道商名称
     */
    private String supplierName;

    /**
     * 上游渠道商备付金账户编码
     */
    private String acctCode;
    /**
     *  账户名称
     */
    private String acctName;
    /**
     * 面值
     */
    @DecimalMin("0.001")
    @Digits(integer = 20, fraction = 3,message = "面值价必须是大于0且最多3位小数的数字！")
    private BigDecimal price;
    /**
     * 产品采购价
     */
    @DecimalMin("0.001")
    @Digits(integer = 20, fraction = 3,message = "采购价必须是大于0且最多3位小数的数字！")
    private BigDecimal purchasePrice;
    
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    @Min(0)
    @Max(1)
    @NotNull
    private Integer isRelateDeposit;
    
    
    /**
     * 渠道产品类型
     */
    private ChannelProductTypeEnum channelProductType;
    
    /**
     * 渠道产品编码
     * 广州大诚时使用
     * @link{com.rocogz.supplychain.api.enums.supplychain.SupplierChannel#GZ_ROCO}
     * 兑换券 固定为ROCO_POINT， 代金券为  车服基准券编码
     */
    private String channelProductCode;

}
