package com.rocogz.supplychain.api.request.supplychain.seller.product;

import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/2/19 11:15 上午
 */
@Data
public class SellerProductUpdateReq implements Serializable {

    @NotNull
    @Min(1)
    private Long id;
    /**
     * 产品编号
     */
    @NotBlank(message = "编号不能为空")
    private String code;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 简称
     */
    @NotBlank(message = "简称不能为空")
    private String simpleName;
    /**
     * 类目编码
     */
    @NotBlank(message = "分类不能为空")
    private String catalogCode;
    /**
     * 分类名称
     */
    private String catalogName;
    /**
     * 品牌编码
     */
    @NotBlank(message = "品牌不能为空")
    private String brandCode;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 下游销售商编码
     */
   // private String sellerNo;

    /**
     * 下游销售商名称
     */
   // private String sellerName;

    /**
     * 下游销售商备付金账户编码
     */
   // private String acctCode;
    /**
     *  账户名称
     */
   // private String acctName;

    /**
     * 面值
     */
    @DecimalMin("0.001")
    @Digits(integer = 20, fraction = 3,message = "面值价必须是大于0且最多3位小数的数字！")
    private BigDecimal price;
    /**
     * 产品采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 产品销售价
     */
    @DecimalMin("0.001")
    @Digits(integer = 20, fraction = 3,message = "销售价必须是大于0且最多3位小数的数字！")
    private BigDecimal sellPrice;
    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    /**
     * 上游产品编号
     */
    @NotBlank(message = "上游产品编号不能为空")
    private String upstreamCode;

}
