package com.rocogz.supplychain.api.service.supplier;

import com.rocogz.common.api.request.BasePrimaryKeyRequest;
import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;
import com.rocogz.supplychain.api.entity.supplychain.SellerProduct;
import com.rocogz.supplychain.api.entity.supplychain.SellerProductHistory;
import com.rocogz.supplychain.api.request.supplychain.seller.product.*;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
public interface SellerProductService {

    /**
     * 新增产品
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SellerProductSaveReq> request);


    /**
     * 分页查询产品
     * @param request
     * @return
     */
    CommonQueryPageResponse<SellerProduct> page(CommonQueryPageRequest<SellerProductPageReq> request);

    /**
     * 产品详情
     * @param request
     * @return
     */
    CommonResponse<SellerProduct> detail(CommonRequest<BasePrimaryKeyRequest> request);


    CommonResponse<SellerProduct> getSimpleByCode(CommonRequest<BaseUniqueCodeRequest> request);


    /**
     * 变更状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SellerProductStatusUpdateReq> request);


    /**
     * 产品修改
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<SellerProductUpdateReq> request);



    /**
     * 根据产品编号查询产品详情
     * @param request
     * @return
     */
    CommonResponse<SellerProduct> detailByCode(CommonRequest<SellerProductDetailReq> request);
    /**
     * 根据产品编号查询产品变更历史
     * @param request
     * @return
     */
     CommonQueryPageResponse<SellerProductHistory> history(CommonQueryPageRequest<SellerProductPageReq> request);

}
