/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.swagger.spring.boot.autoconfigure;

import com.rocogz.swagger.spring.boot.autoconfigure.SwaggerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnWebApplication
@ConditionalOnClass(value={Controller.class})
@ConditionalOnMissingBean(value={Docket.class})
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
@Configuration
@ConditionalOnProperty(name={"swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class Swagger2AutoConfiguration {
    @Autowired
    private SwaggerProperties swaggerProp;

    @Bean
    public Docket swaggerRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProp.getBasePackage())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.getTitle()).description(this.getDescription()).termsOfServiceUrl(this.getServiceUrl()).contact(this.getContact()).version(this.getVersion()).build();
        return apiInfo;
    }

    private String getTitle() {
        String title = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getName();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProp.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getName())) {
            title = company.getName();
        }
        return title;
    }

    private String getDescription() {
        String description = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getDescription();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProp.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getDescription())) {
            description = company.getDescription();
        }
        return description;
    }

    private String getServiceUrl() {
        String serviceUrl = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getSiteUrl();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProp.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getSiteUrl())) {
            serviceUrl = company.getSiteUrl();
        }
        return serviceUrl;
    }

    private String getVersion() {
        String version = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getVersion();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProp.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getVersion())) {
            version = company.getVersion();
        }
        return version;
    }

    private Contact getContact() {
        String contactName = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getContactName();
        String contactEmail = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getContactEmail();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProp.getCompany();
        if (company != null) {
            if (!StringUtils.isEmpty((Object)company.getContactName())) {
                contactName = company.getContactName();
            }
            if (!StringUtils.isEmpty((Object)company.getContactEmail())) {
                contactEmail = company.getContactEmail();
            }
        }
        return new Contact(contactName, this.getServiceUrl(), contactEmail);
    }
}

