/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.swagger.spring.boot.autoconfigure;

import com.google.common.base.Predicate;
import com.rocogz.swagger.spring.boot.autoconfigure.ApiAnonAccess;
import com.rocogz.swagger.spring.boot.autoconfigure.SwaggerProperties;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnWebApplication
@ConditionalOnClass(value={Controller.class})
@ConditionalOnMissingBean(value={Docket.class})
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
@Configuration
@ConditionalOnProperty(name={"swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class Swagger2AutoConfiguration {
    @Autowired
    private SwaggerProperties swaggerProps;
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private RequestMappingHandlerMapping handlerMapping;
    private List<String> anonApiPathPatternList;

    @PostConstruct
    private void initAnonApiPath() {
        if (CollectionUtils.isEmpty(this.swaggerProps.getAuthHeaderNameList())) {
            return;
        }
        this.anonApiPathPatternList = new ArrayList<String>();
        Map handlerMethodMap = this.handlerMapping.getHandlerMethods();
        handlerMethodMap.forEach((reqMapping, handlerMethod) -> {
            boolean isAnnoHandlerBean = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)handlerMethod.getBeanType(), ApiAnonAccess.class);
            boolean isAnnoHandlerMethod = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)handlerMethod.getMethod(), ApiAnonAccess.class);
            if (isAnnoHandlerBean || isAnnoHandlerMethod) {
                Set patterns = reqMapping.getPatternsCondition().getPatterns();
                this.anonApiPathPatternList.addAll(patterns);
            }
        });
    }

    @Bean
    public Docket publicSwaggerRestApi() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).groupName("\u533f\u540d\u8bbf\u95ee\u63a5\u53e3").ignoredParameterTypes(this.getIgnoredParameterTypes()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProps.getBasePackage())).paths(this.getAnouAccessPathPredicate()).build();
        return docket;
    }

    @ConditionalOnProperty(name={"swagger.auth-header-names"})
    @Bean
    public Docket authSwaggerRestApi() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).groupName("\u8ba4\u8bc1\u8bbf\u95ee\u63a5\u53e3").ignoredParameterTypes(this.getIgnoredParameterTypes()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProps.getBasePackage())).paths(this.getAuthPathPredicate()).build().securitySchemes(this.security()).securityContexts(this.securityContexts());
        return docket;
    }

    private Class[] getIgnoredParameterTypes() {
        return new Class[]{ModelMap.class, HttpServletRequest.class, HttpServletResponse.class, HttpSession.class};
    }

    private ApiInfo apiInfo() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.getTitle()).description(this.getDescription()).termsOfServiceUrl(this.getServiceUrl()).contact(this.getContact()).version(this.getVersion()).build();
        return apiInfo;
    }

    private String getTitle() {
        String title = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getName();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProps.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getName())) {
            title = company.getName();
        }
        return title;
    }

    private String getDescription() {
        String description = null;
        SwaggerProperties.CompanyCopyRight company = this.swaggerProps.getCompany();
        description = company != null && !StringUtils.isEmpty((Object)company.getDescription()) ? company.getDescription() : this.env.getProperty("spring.application.name");
        if (StringUtils.isEmpty((Object)description)) {
            description = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getDescription();
        }
        return description;
    }

    private String getServiceUrl() {
        String serviceUrl = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getSiteUrl();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProps.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getSiteUrl())) {
            serviceUrl = company.getSiteUrl();
        }
        return serviceUrl;
    }

    private String getVersion() {
        String version = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getVersion();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProps.getCompany();
        if (company != null && !StringUtils.isEmpty((Object)company.getVersion())) {
            version = company.getVersion();
        }
        return version;
    }

    private Contact getContact() {
        String contactName = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getContactName();
        String contactEmail = SwaggerProperties.CompanyCopyRight.DEFAULT_COMPANY.getContactEmail();
        SwaggerProperties.CompanyCopyRight company = this.swaggerProps.getCompany();
        if (company != null) {
            if (!StringUtils.isEmpty((Object)company.getContactName())) {
                contactName = company.getContactName();
            }
            if (!StringUtils.isEmpty((Object)company.getContactEmail())) {
                contactEmail = company.getContactEmail();
            }
        }
        return new Contact(contactName, this.getServiceUrl(), contactEmail);
    }

    private List<ApiKey> security() {
        ArrayList<ApiKey> list = new ArrayList<ApiKey>();
        String passAs = "header";
        for (String authHeaderName : this.swaggerProps.getAuthHeaderNameList()) {
            list.add(new ApiKey(authHeaderName, authHeaderName, passAs));
        }
        return list;
    }

    private Predicate<String> getAnouAccessPathPredicate() {
        if (CollectionUtils.isEmpty(this.swaggerProps.getAuthHeaderNameList())) {
            return PathSelectors.any();
        }
        if (CollectionUtils.isEmpty(this.anonApiPathPatternList)) {
            return PathSelectors.none();
        }
        return new Predicate<String>(){

            public boolean apply(String input) {
                AntPathMatcher matcher = new AntPathMatcher();
                for (String anonPathPattern : Swagger2AutoConfiguration.this.anonApiPathPatternList) {
                    if (!matcher.match(anonPathPattern, input)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Predicate<String> getAuthPathPredicate() {
        if (CollectionUtils.isEmpty(this.anonApiPathPatternList)) {
            return PathSelectors.any();
        }
        return new Predicate<String>(){

            public boolean apply(String input) {
                AntPathMatcher matcher = new AntPathMatcher();
                for (String anonPathPattern : Swagger2AutoConfiguration.this.anonApiPathPatternList) {
                    if (!matcher.match(anonPathPattern, input)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(this.getAuthPathPredicate()).build());
        return securityContexts;
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("global", "accessEverything")};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        for (String authHeaderName : this.swaggerProps.getAuthHeaderNameList()) {
            securityReferences.add(new SecurityReference(authHeaderName, authorizationScopes));
        }
        return securityReferences;
    }
}

