/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.swagger.spring.boot.autoconfigure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="swagger")
public class SwaggerProperties {
    private Boolean enabled;
    private String basePackage;
    private String authHeaderNames;
    private String anonApiPathPatterns;
    private CompanyCopyRight company;

    public List<String> getAuthHeaderNameList() {
        if (!StringUtils.hasText((String)this.authHeaderNames)) {
            return Collections.emptyList();
        }
        return Arrays.stream(StringUtils.trimArrayElements((String[])this.authHeaderNames.split(","))).collect(Collectors.toList());
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setAuthHeaderNames(String authHeaderNames) {
        this.authHeaderNames = authHeaderNames;
    }

    public void setAnonApiPathPatterns(String anonApiPathPatterns) {
        this.anonApiPathPatterns = anonApiPathPatterns;
    }

    public void setCompany(CompanyCopyRight company) {
        this.company = company;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getAuthHeaderNames() {
        return this.authHeaderNames;
    }

    public String getAnonApiPathPatterns() {
        return this.anonApiPathPatterns;
    }

    public CompanyCopyRight getCompany() {
        return this.company;
    }

    public static class CompanyCopyRight {
        static final CompanyCopyRight DEFAULT_COMPANY = new CompanyCopyRight();
        private String name;
        private String siteUrl;
        private String description;
        private String version;
        private String contactName;
        private String contactEmail;

        public void setName(String name) {
            this.name = name;
        }

        public void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public String getName() {
            return this.name;
        }

        public String getSiteUrl() {
            return this.siteUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String getContactName() {
            return this.contactName;
        }

        public String getContactEmail() {
            return this.contactEmail;
        }

        static {
            DEFAULT_COMPANY.setName("\u5e7f\u5dde\u5927\u8bda\u82e5\u8c37\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8");
            DEFAULT_COMPANY.setDescription("\u5e7f\u5dde\u5927\u8bda\u9879\u76ee");
            DEFAULT_COMPANY.setSiteUrl("http://www.rocoinfo.com");
            DEFAULT_COMPANY.setContactName("\u5e7f\u5dde\u5927\u8bda\u6280\u672f\u90e8");
            DEFAULT_COMPANY.setContactEmail("admin_tech@rocogz.com");
            DEFAULT_COMPANY.setVersion("V1.0");
        }
    }
}

