package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户消息盒子
 * </p>
 *
 * @author luoyingchang
 * @since 2020-06-11
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("user_msg_box")
public class UserMsgBox extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 未读消息条数
     */
    private Integer unreadMsgTotal;

    /**
     * 消息盒子创建时间
     */
    private LocalDateTime createTime;

}
