package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户消息类型
 * </p>
 *
 * @author luoyingchang
 * @since 2020-06-11
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("user_msg_type")
public class UserMsgType extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 未读消息条数
     */
    private Integer unreadMsgTypeTotal;

    /**
     * 消息类型
     */
    private String msgType;

    /**
     * 消息类型小图标
     */
    private String msgTypeIcon;

    /**
     * 消息类型文案
     */
    private String msgTypeContent;

    /**
     * 最后消息的id
     */
    private Integer lastUserMsgId;

    /**
     * 最后消息的时间
     */
    private LocalDateTime lastUserMsgTime;

    /**
     * 消息盒子创建时间
     */
    private LocalDateTime createTime;

}
